/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.vertex;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;

public class VertexFormatDescription {
    private static final Element[] COMMON_ELEMENTS = Element.values();
    private final int[] elementOffsets = new int[COMMON_ELEMENTS.length];
    private final VertexFormat format;
    private static final Map<VertexFormat, VertexFormatDescription> REGISTRY = new Reference2ReferenceOpenHashMap();
    private static final StampedLock LOCK = new StampedLock();

    VertexFormatDescription(VertexFormat format) {
        Arrays.fill(this.elementOffsets, -1);
        this.format = format;
        for (int i = 0; i < format.func_177345_h(); ++i) {
            Element commonElement = Element.VANILLA_TO_COMMON.get(format.func_177348_c(i));
            if (commonElement == null) continue;
            this.elementOffsets[commonElement.ordinal()] = format.func_181720_d(i) / 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VertexFormatDescription get(VertexFormat format) {
        VertexFormatDescription desc;
        long stamp = LOCK.readLock();
        try {
            desc = REGISTRY.get(format);
        }
        finally {
            LOCK.unlockRead(stamp);
        }
        if (desc != null) {
            return desc;
        }
        desc = new VertexFormatDescription(format);
        stamp = LOCK.writeLock();
        try {
            REGISTRY.put(format, desc);
        }
        finally {
            LOCK.unlockWrite(stamp);
        }
        return desc;
    }

    public int getIndex(Element element) {
        return this.elementOffsets[element.ordinal()];
    }

    public static enum Element {
        POSITION(DefaultVertexFormats.field_181713_m),
        COLOR(DefaultVertexFormats.field_181714_n),
        TEXTURE(DefaultVertexFormats.field_181715_o),
        NORMAL(DefaultVertexFormats.field_181717_q);

        final VertexFormatElement underlyingElement;
        static final Map<VertexFormatElement, Element> VANILLA_TO_COMMON;

        private Element(VertexFormatElement baseElement) {
            this.underlyingElement = baseElement;
        }

        static {
            VANILLA_TO_COMMON = new Object2ObjectOpenHashMap();
            for (Element e : Element.values()) {
                VANILLA_TO_COMMON.put(e.underlyingElement, e);
            }
        }
    }
}

